﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NUnit.Framework;
using Inet.Viewer.Data;
using Inet.Viewer.WinForms;
using Inet.Viewer.WinForms.Prompt;

namespace Inet.Viewer.test.WinForms
{
    [TestFixture]
    class TestPromptList
    {
        [Test]
        public void TestPromptListNavigation()
        {
            PromptData p1 = new PromptData(
                "prompt", null, "desc", new string[] { }, new string[] { }, PromptData.String,
                true, false, false, true, false,
                false, null, null, null);
            PromptData p2 = new PromptData(
                "prompt2", null, "desc", new string[] { }, new string[] { }, PromptData.Number,
                true, false, false, true, false,
                false, null, null, null);

            List<PromptData> prompts = new List<PromptData>();
            prompts.Add(p1);
            prompts.Add(p2);
            PromptDialogForm d = new PromptDialogForm(prompts, new PromptPanelBuilder(),false);
            d.Show();
            Assert.IsFalse(d.btnLeft.Enabled);
            Assert.IsTrue(d.btnRight.Enabled);
            d.btnRight.PerformClick();
            Assert.IsFalse(d.btnRight.Enabled);
            Assert.IsTrue(d.btnLeft.Enabled);
            d.btnLeft.PerformClick();
            Assert.IsFalse(d.btnLeft.Enabled);
            Assert.IsTrue(d.btnRight.Enabled);
        }
    }
}
